(() => {
    'use strict';

    const _Game_Battler_initialize = Game_Battler.prototype.initialize;
    Game_Battler.prototype.initialize = function(actorId) {
        _Game_Battler_initialize.call(this);
        
        // カウンター用フラグの宣言
        this.counterFlg = false;
    };

    // 被ダメージモーションの処理
    const _Game_Actor_performDamage = Game_Actor.prototype.performDamage;
    Game_Actor.prototype.performDamage = function() {
        // カウンター用攻撃中なら被ダメ演出を出さない
        if (this.counterFlg) {
            this.counterFlg = false;
            SoundManager.playActorDamage();
        } else {
            _Game_Actor_performDamage.call(this);
        }
    };

    // ゲームアクションの初期化処理
    const _Game_Action_initialize = Game_Action.prototype.initialize;
    Game_Action.prototype.initialize = function(subject, forcing) {
        _Game_Action_initialize.call(this, subject, forcing);
        
        // カウンター用のフラグをセット
        this._isCounter = false;
    };

    // カウンターの判定処理
    Game_Action.prototype.itemCnt = function(target) {
        // アクションがカウンターの場合はカウンター判定を行わない
        if (this._isCounter) return 0;

        if (this.isPhysical() && target.canMove()) {
            return target.cnt;
        } else {
            return 0;
        }
    };

    // ダメージ判定処理
    Game_Action.prototype.apply = function(target) {
        const result = target.result();
        this.subject().clearResult();
        result.clear();
        result.used = this.testApply(target);
        result.missed = result.used && Math.random() >= this.itemHit(target);
        result.evaded = !result.missed && Math.random() < this.itemEva(target);
        result.physical = this.isPhysical();
        result.drain = this.isDrain();
        if (result.isHit()) {
            if (this.item().damage.type > 0) {
                result.counter = Math.random() < this.itemCnt(target);

                // カウンター成功ならターゲットにフラグを立てる
                if (result.counter){
                    target.counterFlg = true;
                }

                result.critical = Math.random() < this.itemCri(target);
                const value = this.makeDamageValue(target, result.critical);
                this.executeDamage(target, value);
            }
            for (const effect of this.item().effects) {
                this.applyItemEffect(target, effect);
            }
            this.applyItemUserEffect(target);
        }
        this.updateLastTarget(target);
    };

    // ダメージ計算式（スキルの計算式は使わない）
    Game_Action.prototype.evalDamageFormula = function(target) {
        try {
            // ダメージの基本は攻撃者の攻撃力
            return this.subject().atk;
        } catch (e) {
            return 0;
        }
    };

    // ダメージの補正用（属性とかその他もろもろ）
    Game_Action.prototype.makeDamageValue = function(target, critical) {
        const item = this.item();
        const baseValue = this.evalDamageFormula(target);
        let value = baseValue * this.calcElementRate(target);
        if (this.isPhysical()) {
            value *= target.pdr;
        }
        if (this.isMagical()) {
            value *= target.mdr;
        }

        // 攻撃者の旺盛、背水の分だけダメージを補正
        value = value * this.subject().vig / 100;
        value = value * this.subject().las / 100;

        // ターゲットの不屈、盤石の分だけダメージ補正
        value = value * this.subject().uny / 100;
        value = value * this.subject().for / 100;

        if (baseValue < 0) {
            value *= target.rec;
        }
        if (critical) {
            value = this.applyCritical(value);
        }
        // 分散はとりあえず２０で固定
        value = this.applyVariance(value, 20);
        value = this.applyGuard(value, target);
        value = Math.round(value);

        // 攻撃者のダメージ上限で制限をかける
        return Math.min(value, this.subject().maxDamage());
    };

    // クリティカルの適応処理
    Game_Action.prototype.applyCritical = function(damage) {
        let value = damage * 1.5;

        // 超会心の判定
        if (Math.random() < this.subject().scr){
            value *= 1.5;
        }

        return value;
    };

    // アクションリザルトのフラグクリア処理
    const _Game_ActionResult_clear = Game_ActionResult.prototype.clear;
    Game_ActionResult.prototype.clear = function() {
        _Game_ActionResult_clear.call(this);

        // カウンター成功フラグのクリア処理
        this.counter = false;
    };

    // 戦闘中のログ表示の削除
    Window_BattleLog.prototype.addText = function(text) {
        // 何もしない
    };

    // 攻撃アニメーションの表示処理
    Window_BattleLog.prototype.showActorAttackAnimation = function(subject, targets) {
        this.showNormalAnimation(targets, subject.attackAnimationId1(), false);
        // 二刀流の場合のアニメーションの無効化
        //this.showNormalAnimation(targets, subject.attackAnimationId2(), true);
    };

    // テキスト系コマンドだけ無効
    const _push = Window_BattleLog.prototype.push;
    Window_BattleLog.prototype.push = function(methodName) {
        if (methodName === "addText") return;
        _push.apply(this, arguments);
    };

    // 戦闘中のウェイトカウント調整（フレーム）
    Window_BattleLog.prototype.wait = function() {
        this._waitCount = 1;
    };

    // 戦闘中のゲージ描画
    Window_StatusBase.prototype.placeBasicGauges = function(actor, x, y) {
        // HPだけ描画すればいい
        this.placeGauge(actor, "hp", x, y);
        // this.placeGauge(actor, "mp", x, y + this.gaugeLineHeight());
        // if ($dataSystem.optDisplayTp) {
        //     this.placeGauge(actor, "tp", x, y + this.gaugeLineHeight() * 2);
        // }
    };

    // アクションのモーションスピード
    Sprite_Actor.prototype.motionSpeed = function() {
        return 12;
    };

    // 画面サイズ変更時のアクターの位置変更
    // 割合基準で設定
    Sprite_Actor.prototype.setActorHome = function(index) {
        const x = Graphics.width * 0.75;
        const baseY = Graphics.height * 0.5;
        const spacing = 48;
        this.setHome(x, baseY + index * spacing);
    };

    // 戦闘中のゲージの幅を変更する
    Sprite_Gauge.prototype.bitmapWidth = function() {
       return 240;
    };

    // 行動順設定
    // 味方が先で敵が確定後攻
    BattleManager.makeActionOrders = function() {
        this._actionBattlers = [];

        for (const actor of $gameParty.members()) {
            if (actor.canMove()) {
                this._actionBattlers.push(actor);
            }
        }

        for (const enemy of $gameTroop.members()) {
            if (enemy.canMove()) {
                this._actionBattlers.push(enemy);
            }
        }
    };

    // カウンター判定の改造
    // カウンターは攻撃を受けてから発動するように変更
    BattleManager.invokeAction = function(subject, target) {
        this._logWindow.push("pushBaseLine");

        if (Math.random() < this._action.itemMrf(target)) {
            this.invokeMagicReflection(subject, target);
        } else {
            this.invokeNormalAction(subject, target);
        }

        // カウンター判定処理
        // カウンター結果はリザルトに入ってるはずなのでそっちを参照
        if (target.result().counter && target.canMove()) {
            this.invokeAfterDamageCounter(subject, target);
        }
        
        subject.setLastTarget(target);
        this._logWindow.push("popBaseLine");
    };

    // カウンター仕様変更つき新しくカウンター処理を定義
    BattleManager.invokeAfterDamageCounter = function(subject, target) {
        // カウンター用の行動設定
        const action = new Game_Action(target);
        action.setAttack();
        action._isCounter = true;
        this._action = action;
        this._targets = [subject];
        this._subject = target;
        this._logWindow.startAction(this._subject, this._action, this._targets);
        
        // カウンター文字表示用のフラグ
        BattleManager.showPopupText(target, "カウンター！");
    };

})();